unit DebugSupport;

// Brian Long - Embarcadero MVP
// Email - brian@blong.com
// Web  - http://blong.com
// Blog - http://blog.blong.com

{$IFDEF Ver100} { Delphi 3.0x }
  {$DEFINE Delphi3}
{$ENDIF}
{$IFDEF Ver110} { C++ Builder 3.0x }
  {$DEFINE Delphi3}
{$ENDIF}
{$IFDEF Ver120} { Delphi 4.0x }
  {$DEFINE Delphi4}
{$ENDIF}
{$IFDEF Ver125} { C++Builder 4.0x }
  {$DEFINE Delphi4}
{$ENDIF}
{$IFDEF ConditionalExpressions}
  {$DEFINE Delphi6AndAbove}
{$ENDIF}

{$IFDEF Delphi3}
  'This unit requires Delphi 4 or later'
{$ENDIF}

interface

procedure DebugMsg(const Msg: String; ShowPIDAndTID: Boolean = False); overload;
procedure DebugMsg(const Msg: String; const Params: array of const;
  ShowPIDAndTID: Boolean = False); overload;

implementation

uses
{$IFDEF Delphi6AndAbove}
  Variants,
{$ENDIF}
  SysUtils, Windows;

//This returns the passed message, prepending PID & TID info to it if needed
function MakeDebugMsg(const Msg: String; ShowPIDAndTID: Boolean): String;
begin
  if ShowPIDAndTID then
    Result := Format('PID = %d ($%0:x), TID = %d ($%1:x): %s',
      [GetCurrentProcessID, GetCurrentThreadID, Msg])
  else
    Result := Msg;
end;

procedure InternalDebugMsg(const Msg: String);
begin
  OutputDebugString(PChar(Msg))
end;

procedure DebugMsg(const Msg: String; ShowPIDAndTID: Boolean = False); overload;
begin
  InternalDebugMsg(MakeDebugMsg(Msg, ShowPIDAndTID));
end;

procedure DebugMsg(const Msg: String; const Params: array of const;
  ShowPIDAndTID: Boolean = False); overload;
begin
  DebugMsg(Format(Msg, Params), ShowPIDAndTID)
end;

initialization
  // Ensure these two routines are definitely linked
  // into the EXE, so breakpoints can use them
  // Although... in Delphi XE6 using TimeToStr(Time) in a watch expression
  // produces a message that the requested routines have been elimiated by the linker
  TimeToStr(Time);
finalization
end.
